<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface SupplierDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Supplier 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param supplier primary key
 	 */
	public function delete($supplierid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Supplier supplier
 	 */
	public function insert($supplier);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Supplier supplier
 	 */
	public function update($supplier);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySuppliername($value);

	public function queryBySupplieraddress($value);

	public function queryBySupplierphone($value);

	public function queryBySuppliercurrentDebt($value);

	public function queryBySupplierdetails($value);

	public function queryByCondition($value);

	public function queryByUserid($value);

	public function queryBySupplierdate($value);


	public function deleteBySuppliername($value);

	public function deleteBySupplieraddress($value);

	public function deleteBySupplierphone($value);

	public function deleteBySuppliercurrentDebt($value);

	public function deleteBySupplierdetails($value);

	public function deleteByCondition($value);

	public function deleteByUserid($value);

	public function deleteBySupplierdate($value);


}
?>